<?php
/**
*
*
*    InfoBar
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.5.0
*    Visit us at http://www.inno-mods.io
*
*
**/

/*
* check presta
*/
if (!defined('_PS_VERSION_')) {
    exit;
}

/*
* require our model
*/
require_once _PS_MODULE_DIR_.'infobar/models/InfoBar.php';

/*
* InfoBar Module
*/
class Infobar extends Module
{

    /*
    * constructor
    */
    public function __construct()
    {
        $this->name = 'infobar';
        $this->tab = 'front_office_features';
        $this->version = '1.5.0';
        $this->author = 'Inno-mods.io';
        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => '9.99.99' );
        $this->bootstrap = true;

        parent::__construct(); //needed for translations

        $this->displayName = $this->l('Info Bar');
        $this->description = $this->l('Info Bar is a plugin for adding an html info bar at the top or bottom of your shop !! ');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall '.$this->displayName.'?');
    }


    /*
    * install
    */
    public function install()
    {
        if (Shop::isFeatureActive()) { //  check whether the multistore feature is active or not, and if at least two stores are presently activated
            Shop::setContext(Shop::CONTEXT_ALL); // change the context in order  to apply coming changes to all existing stores instead of only the current store
        }

        if (!parent::install() || // install
            !InfoBarModel::createSchema() || // create database
            !$this->registerHook('displayHeader') || // register header hook
            !$this->registerHook('displayFooter') || // register footer hook
            !$this->registerHook('displayBackOfficeHeader')) { // register admin header hook
            return false;
        }

        // return true
        return true;
    }


    /*
    * uninstall
    */
    public function uninstall()
    {
        // uninstall the module
        if (!parent::uninstall() || // uninstall
            !InfoBarModel::DropSchema()) { // drop database
            return false;
        }

        // return
        return true;
    }


    /*
    * getHeader in admin
    */
    public function getHeader()
    {
        // assign to smarty
        $this->smarty->assign(array(
                                    'logoSrc'             => _PS_BASE_URL_.$this->_path.'/views/img/logo-white.png',
                                    'storeName'           => $this->context->shop->name,
                                    'uri'                 => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.''
                                    ));
        // return
        return $this->display(__FILE__, 'views/templates/admin/header.tpl');
    }



    /*
    * getFooter in Admin
    */
    public function getFooter()
    {
        $this->smarty->assign(array(
                                    'moduleVersion'       => $this->version ,
                                    ));
        return $this->display(__FILE__, 'views/templates/admin/footer.tpl');
    }


    /*
    * getContent - actually it works like a module index page
    */
    public function getContent()
    {
        $output = null;

        // baseAdminModuleUrl
        $baseAdminModuleUrl = AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules').'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name.'';

        /*
        * case of saving a block
        */
        if (Tools::isSubmit('FormSubmit')) {
            // get languages
            $langs = $this->getLanguagesList();

            // if id_infobar posted
            if ((int)Tools::getValue('id_infobar')) {
                /*
                * Update
                */
                $settings = new InfoBarModel((int)Tools::getValue('id_infobar'));

                // assign id_store
                $settings->id_store = (int)$this->context->shop->id;
                // assign status
                $settings->status = (int)Tools::getValue('status');
                // assign height
                $settings->height = (int)Tools::getValue('height');
                // assign border size
                $settings->border_size = (int)Tools::getValue('border_size');
                // assign border color
                $settings->border_color = Tools::getValue('border_color');
                // assign background color
                $settings->background_color = Tools::getValue('background_color');
                // assign location
                $settings->location = Tools::getValue('location');

                $content = array();

                // foreach shop language prepare respective data
                foreach ($langs as $lang) {
                    $content[$lang['id_lang']] = Tools::getValue('content_'.$lang['id_lang']);
                }

                // assign multilanguage data
                $settings->content  = $content;

                // save block
                $settings->save();

                // display success message
                $output = '<div class="alert alert-success">'.$this->l('Settings saved succesfully!!').'</div>';
            } else {
                /*
                * Insert
                */
                $settings = new InfoBarModel();

                // assign id_store
                $settings->id_store = (int)$this->context->shop->id;
                // assign status
                $settings->status = (int)Tools::getValue('status');
                // assign height
                $settings->height = (int)Tools::getValue('height');
                // assign border size
                $settings->border_size = (int)Tools::getValue('border_size');
                // assign border color
                $settings->border_color = Tools::getValue('border_color');
                // assign background color
                $settings->background_color = Tools::getValue('background_color');
                // assign location
                $settings->location = Tools::getValue('location');

                $content = array();
                // foreach shop language prepare respective data
                foreach ($langs as $lang) {
                    $content[$lang['id_lang']] = Tools::getValue('content_'.$lang['id_lang']);
                }

                // assign multilanguage data
                $settings->content  = $content;

                // save block
                $settings->save();

                // display success message
                $output = '<div class="alert alert-success">'.$this->l('Settings saved succesfully!!').'</div>';
            }

        } // save end

        // return
        return $this->getHeader().$output.$this->displayForm().$this->getFooter();
    }


    /*
    * displayForm
    */
    public function displayForm()
    {
        // Get default Language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        // Init Fields form array
        $fields_form = array();
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Settings'),
                'icon' => 'icon-cogs'
            ),
            'input' => array(
                array(
                    'type'     => 'hidden',
                    'name'     => 'FormSubmit',
                ),
                array(
                    'type'     => 'hidden',
                    'name'     => 'id_infobar',
                ),
                array(
                    'type'     => 'hidden',
                    'name'     => 'id_store',
                ),
                array(
                    'type' =>  'switch',
                    'label' => $this->l('Active'),
                    'name' => 'status',
                    'class'     => 't',
                    'is_bool'   => true,
                    'values' => array(
                                    array(
                                        'id' => 'active_on',
                                        'value' => 1,
                                        'label' => $this->l('Enabled')
                                    ),
                                    array(
                                        'id' => 'active_off',
                                        'value' => 0,
                                        'label' => $this->l('Disabled')
                                    )
                    ),
                    'desc'     => $this->l('Activate / Deactivate Info Bar functionality for Current Store.'),
                ),
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Bar Height'),
                    'name'     => 'height',
                    'desc'     => $this->l('Bar height in pixels. Fill in a number bigger than 0. '),
                ),
                array(
                    'type'     => 'text',
                    'label'    => $this->l('Border Size'),
                    'name'     => 'border_size',
                    'desc'     => $this->l('Fill in the size of the Info Bar ( in pixels ) '),
                ),
                array(
                    'type'     => 'color',
                    'label'    => $this->l('Border Color'),
                    'name'     => 'border_color',
                    'desc'     => $this->l('Fill in the border color.'),
                ),
                array(
                    'type'     => 'color',
                    'label'    => $this->l('Background Color'),
                    'name'     => 'background_color',
                    'desc'     => $this->l('Fill in the background color.'),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Location'),
                    'name' => 'location',
                    'options' => array(
                                    'query' => array(
                                                    array( 'id_option'=> 'top','name'=> 'top'),
                                                    array( 'id_option'=> 'bottom','name'=> 'bottom'),
                                                    ),
                    'id' => 'id_option',
                    'name' => 'name'
                    )
                ),
                array(
                    'type'     => 'textarea',
                    'label'    => $this->l('Bar Content'),
                    'name'     => 'content',
                    'desc'     => $this->l('Visible to your visitors'),
                    'rows'     => 10,
                    'cols'     => 100,
                    'autoload_rte' => true,
                    'lang'     => true
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'class' => 'button'
            )
        );



        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        // Language
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        // Title
        $helper->title = $this->l('Settings');

        // Toolbar
        $helper->show_toolbar = false;        // false -> remove toolbar
        $helper->toolbar_scroll = false;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
                                    'save' => array(
                                                    'desc' => $this->l('Save'),
                                                    'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                                                    '&token='.Tools::getAdminTokenLite('AdminModules'),
                                                )
                                );

        $helper->tpl_vars = array(
            'fields_value' =>  $this->getSettings() ,
            'languages' => $this->getLanguagesList(),
            'id_language' => $this->context->language->id,
        );


        return $helper->generateForm($fields_form);
    }




    /*
    * get current store settings
    */
    public function getSettings()
    {
        // check bar id for current store
        $bar = InfoBarModel::getCurrentStoreInfobarId((int)$this->context->shop->id);
        // if bar found for current store
        if ($bar) {
            // load object
            $settings = new InfoBarModel((int)$bar['id_infobar']);

            // return current store settings
            return array(
                'FormSubmit'                    => true,
                'id_infobar'                    => (int)$bar['id_infobar'],
                'id_store'                      => $this->context->shop->id,
                'status'                        => $settings->status,
                'height'                        => $settings->height,
                'border_size'                   => $settings->border_size,
                'location'                      => $settings->location,
                'border_color'                  => $settings->border_color,
                'background_color'              => $settings->background_color,
                'content'                       => $settings->content
            );
        } else {
            // prepare an empty name / content array for each language
            foreach($this->getLanguagesList() as $lang){
              $emptyLanguageArray[$lang['id_lang']] = '';
            }

            // else return default ones
            return array(
                'FormSubmit'                    => true,
                'id_infobar'                    => '',
                'id_store'                      => $this->context->shop->id,
                'status'                        => '0',
                'height'                        => '50',
                'border_size'                   => '1',
                'location'                      => 'top',
                'border_color'                  => '#555555',
                'background_color'              => '#ffffff',
                'content'                       => $emptyLanguageArray
            );
        }
    }



    /*
    * getLanguagesList
    */
    public function getLanguagesList()
    {
        $languages_list = array();
        $langs = Language::getLanguages(true, $this->context->shop->id);

        foreach ($langs as $lang) {
            if ($lang['id_lang'] == $this->context->language->id) {
                $isDefault = 1;
            } else {
                $isDefault = 0;
            }

            $languages_list[] = array(
                                        'id_lang' => $lang['id_lang'],
                                        'name' => $lang['name'],
                                        'is_default' => $isDefault ,
                                        'iso_code' => $lang['iso_code'],
                                    );
        }

        return $languages_list;
    }


    /*
    * getShopsList
    */
    private function getShopsList()
    {
        $shops_list = array();
        $shops = Shop::getShops();
        foreach ($shops as $shop) {
            $shops_list[] = array( 'id_shop' => $shop['id_shop'], 'name' => $shop['name'] );
        }

        // return shops
        return $shops_list;
    }

    /*
    * getShopsListIds
    */
    private function getShopsListIds()
    {
        $shops_list = array();
        $shops = Shop::getShops();
        foreach ($shops as $shop) {
            $shops_list[] = $shop['id_shop'];
        }

        // return shop ids
        return $shops_list;
    }



    /*
    * psMajorVersion
    */
    public static function psMajorVersion()
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        return $exp[0];
    }


    /*
    * psVersion
    */
    public function psVersion()
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        return $exp[0].'.'.$exp[1];
    }

    /*
    * includes for back office
    */
    public function hookDisplayBackOfficeHeader($params)
    {
        // add jquery for PS < 9
        if ($this->psMajorVersion() < '9') {
            $this->context->controller->addJquery();
        }
        $this->context->controller->addCSS($this->_path.'/views/css/infobar_back_office.css', 'all');
    }



    /*
    * hookDisplayFooter
    */
    public function hookDisplayHeader($params)
    {
        // add jquery for PS < 9
        if ($this->psMajorVersion() < '9') {
            $this->context->controller->addJquery();
        }
        $this->context->controller->addCSS(($this->_path).'/views/css/infobar.css', 'all');
        $this->context->controller->addJS(($this->_path).'/views/js/infobar.js', 'all');
    }

    /*
    * hookDisplayFooter
    */
    public function hookDisplayFooter($params)
    {
        // check for an active non-empty bottom info bar for current shop and current lang
        $settings = InfoBarModel::getDisplayableInfoBar((int)$this->context->shop->id, (int)$this->context->language->id);
        // if settings found
        if ($settings){
            // assign to smarty
            $this->smarty->assign(array(
                                        'settings' => $settings
                                        ));
            if ($this->psMajorVersion()=='1'){
                if ($this->psVersion()=='1.7'){
                    // return tpl
                    return $this->display(__FILE__, 'views/templates/front/infobar-1.7.tpl');
                }
            } else if ($this->psMajorVersion()>='8'){
                // return tpl
                return $this->display(__FILE__, 'views/templates/front/infobar-8.tpl');
            }
        }
    }

    /*
    * End of: infobar.php
    */
}
