<?php
/**
*
*
*    InfoBar
*    Copyright 2015  Inno-mods.io
*
*    @author    Inno-mods.io
*    @copyright Inno-mods.io
*    @version   1.5.0
*    Visit us at http://www.inno-mods.io
*
*
**/

class InfoBarModel extends ObjectModel
{

    /*
    * definition
    */
    public $id_infobar;
    public $id_store;
    public $height;
    public $location;
    public $position;
    public $border_size;
    public $border_color;
    public $background_color;
    public $status;
    public $content;

    public static $definition = array(
                                        'table' => 'infobar',
                                        'primary' => 'id_infobar',
                                        'multishop' => true,
                                        'multilang' => true,
                                        'fields' => array(
                                                            'status' => array(
                                                                            'type' => self::TYPE_INT
                                                                        ),
                                                            'height' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'border_size' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'location' => array(
                                                                            'type' => self::TYPE_STRING,
                                                                            'validate' => 'isString',
                                                                            'required' => true,
                                                                            'size' => 50
                                                                        ),
                                                            'id_store' => array(
                                                                            'type' => self::TYPE_INT,
                                                                            'validate' => 'isUnsignedInt',
                                                                            'required' => true
                                                                        ),
                                                            'border_color' => array(
                                                                        'type' => self::TYPE_HTML,
                                                                        'validate' => 'isString',
                                                                        'required' => true
                                                                        ),
                                                            'background_color' => array(
                                                                        'type' => self::TYPE_HTML,
                                                                        'validate' => 'isString',
                                                                        'required' => true
                                                                        ),
                                                            'content' => array(
                                                                                'type' => self::TYPE_HTML,
                                                                                'lang' => true,
                                                                                'size' => 3999999999999
                                                                            )
                                                        ),
                                    );


    /*
    * createSchema for current Model
    */
    public static function createSchema()
    {
        //main table for the files
        return ( InfoBarModel::createInfoBarTable() && InfoBarModel::createInfoBarLanguageTable() );
    }




    /*
    * dropSchema for current Model
    */
    public static function dropSchema()
    {
        $sql = 'DROP TABLE `'._DB_PREFIX_.self::$definition['table'].'`, `'._DB_PREFIX_.self::$definition['table'].'_lang` ';
        $result = Db::getInstance()->execute($sql);
        return $result;
    }




    /*
    * createInfoBarTable
    */
    public static function createInfoBarTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'`(
                `id_infobar` int(10) unsigned NOT NULL auto_increment,
                `id_store` int(10) unsigned NOT NULL default \'1\',
                `status` int(10) unsigned NOT NULL,
                `height` int(10) unsigned NOT NULL,
                `location` ENUM( "top" , "bottom" ),
                `border_size` int(10) unsigned NOT NULL,
                `border_color` text NOT NULL,
                `background_color` text NOT NULL,
                PRIMARY KEY (`id_infobar`)
                ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }


    /*
    * createInfoBarLanguageTable
    */
    public static function createInfoBarLanguageTable()
    {
        $sql = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.self::$definition['table'].'_lang` (
                    `id_infobar` int(10) unsigned NOT NULL,
                    `id_lang` int(10) unsigned NOT NULL,
                    `content` text NOT NULL,
                    PRIMARY KEY (`id_infobar`,`id_lang`)
                    ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';

        return Db::getInstance()->execute($sql);
    }




    /*
    * getCurrentStoreInfobarId
    */
    public static function getCurrentStoreInfobarId($shop)
    {
        $sql = 'SELECT `id_infobar` FROM `'._DB_PREFIX_.self::$definition['table'].'`
                WHERE `id_store` = "'.(int)$shop.'" ';
        $res = Db::getInstance()->ExecuteS($sql);
        if ($res) {
            return $res[0];
        } else {
            return false;
        }
    }


    /*
    * getDisplayableInfoBar
    */
    public static function getDisplayableInfoBar($shop, $lang)
    {
        $sql = 'SELECT `i`.*,`l`.`content` FROM `'._DB_PREFIX_.self::$definition['table'].'` as `i`
                INNER JOIN `'._DB_PREFIX_.self::$definition['table'].'_lang` as `l` ON `i`.`id_infobar` = `l`.`id_infobar`
                WHERE `i`.`id_store` = "'.(int)$shop.'" AND `l`.`id_lang`="'.(int)$lang.'"  AND `l`.`content` != "" AND `i`.`status` = 1 ';
        $res = Db::getInstance()->executeS($sql);
        if ($res) {
            return $res[0];
        } else {
            return false;
        }
    }

    /*
    * End of InfoBarModel
    */
}
